% ALPHA ENGINE DEFINITION
% Generated 22-Oct-2018 12:48:05

% SUGGESTED CITATION:
% 2013 Ford 1.6L EcoBoost Engine Tier 2 Fuel - ALPHA Map Package. Version 2018-10. Ann Arbor MI: US EPA National Vehicle and Fuel Emissions Laboratory, National Center for Advanced Technology, 2018.


% Constructor
engine = class_REVS_engine();
engine.name =  '2013 Ford 1.6L EcoBoost Engine Tier 2 Fuel'; 
engine.source_filename = mfilename;engine.matrix_vintage = enum_matrix_vintage.present;

% Physical Description
engine.displacement_L =  1.596; 
engine.num_cylinders =  4; 
engine.combustion_type = enum_engine_combustion_type.spark_ignition;
engine.bore_mm =  79; 
engine.stroke_mm =  81.4; 

% Maximum Torque Curve
engine.full_throttle_speed_radps = [	    0.00000000000000000	;     104.71975511965977	;     157.07963267948966	;     209.34699084401964	;     261.79938779914943	;     387.46309394274112	;     492.18284906240092	;     596.90260418206071	;     626.74773439116382	;     656.59286460026681		]; 
engine.full_throttle_torque_Nm = [	    0.00000000000000000	;     132.00000000000000	;     200.00000000000000	;     243.29553398058243	;     250.00000000000000	;     246.00000000000000	;     237.00000000000000	;     223.00000000000000	;     191.14285714285714	;    0.00000000000000000		]; 
engine.naturally_aspirated_speed_radps = [	    0.00000000000000000	;     157.15747577165220	;     209.54028521143078	;     235.72391616090977	;     314.17244772815320	;     418.89158684925337	;     656.59286460026681		]; 
engine.naturally_aspirated_torque_Nm = [	     78.716700122779727	;     113.57129079014379	;     119.97441205454714	;     121.37409995343515	;     119.68852026170057	;     107.40620345523797	;     101.51512738613449		]; 

% Minimum Torque Curve
engine.closed_throttle_speed_radps = [	    0.00000000000000000	;     104.82447487477943	;     287.97932657906438	;     314.05454560385965	;     366.51914291880917	;     471.34361779358858	;     656.59286460026681		]; 
engine.closed_throttle_torque_Nm = [	    -12.951259999999998	;    -13.119999999999999	;    -17.590000000000000	;    -17.620000000000001	;    -13.410000000000000	;    -13.710000000000001	;    -14.008202857142859		]; 

% Fuel Map
engine.fuel_map_speed_radps = [	    0.00000000000000000	;     52.412237437389727	;     104.82447487477945	;     120.53243814272838	;     136.24040141067735	;     157.15747577165220	;     183.36167322064625	;     209.54028521143078	;     235.72391616090977	;     261.80677278188011	;     287.98275148886364	;     314.17244772815320	;     340.44315259952123	;     366.52630842757856	;     392.69908169872417	;     418.89158684925337	;     471.33535044450014	;     523.59877559829886	;     590.09582009928283	;     656.59286460026681		]; 
engine.fuel_map_torque_Nm = [	    -18.501000000000001	;    -14.703437500000000	;    -6.6077777777777786	;     3.7983333333333338	;     20.354838709677416	;     34.722857142857144	;     44.099090909090911	;     57.951666666666668	;     66.469999999999999	;     71.567499999999995	;     87.105185185185178	;     100.58272727272728	;     108.45083333333334	;     116.63499999999999	;     129.06725000000000	;     141.17928571428570	;     155.59583333333330	;     166.65400000000000	;     181.99250000000001	;     197.05437096774193	;     207.45833333333331	;     216.85821213836741	;     225.85797565122704	;     234.85773916408664	;     243.29553398058243	;     252.89776699029122	;     262.50000000000000		]; 
engine.fuel_map_gps = [
  0.011651203437748520	  0.083499933113990704	   0.16065895578235201	   0.18293422096050971	   0.20540852587193645	   0.23681408207393012	   0.28075907480482337	   0.32676695707022174	   0.36615274403365372	   0.39943580842379167	   0.43570124588537545	   0.47883078130355794	   0.52770936704924776	   0.56622880009218268	   0.59859308887437046	   0.62893456798166181	   0.66473941952586291	   0.63662001114545819	   0.69049966735046020	   0.79372067486513154	;
  0.013792681229584505	  0.083499782550736132	   0.15679822893253550	   0.17770847389825706	   0.19852239025421869	   0.22771970727575050	   0.26971770731198619	   0.31427138997618043	   0.35258973719585907	   0.38424845665257579	   0.41663982477917016	   0.46000245340625578	   0.51704647949651217	   0.55741679561451152	   0.58844764247438974	   0.61862910129768833	   0.67255480859222005	   0.71726755218908822	   0.81784706752627279	   0.94058147622746913	;
  0.018262352247307764	  0.083811274889828383	   0.14750492405165022	   0.16603726743877795	   0.18454010618918282	   0.21000333319841238	   0.24822753817495577	   0.28948664717229633	   0.32707193184102196	   0.35878075577747554	   0.38327559972915765	   0.42382328698797023	   0.48873153894945359	   0.53848093328414282	   0.56905749055485078	   0.59601236328510532	   0.68670887193593988	   0.89178079017925171	    1.0892312914748432	    1.2533173401176461	;
  0.022648377895178130	  0.089103112949457039	   0.14473813091135845	   0.16648990940323716	   0.18809337799122144	   0.21694910972033493	   0.25872230663207613	   0.30642434366401938	   0.35132620287346916	   0.39799620013098563	   0.43552998415158456	   0.47720888849689702	   0.53040109988449868	   0.57874292430011676	   0.63088645247865816	   0.68953092578086395	   0.83886984993288749	    1.1471405659301299	    1.4366539553540223	    1.6509481356754321	;
  0.021382479249115044	   0.13143870057312054	   0.24145872577534827	   0.27655091017116035	   0.30942331114685850	   0.35073056581433010	   0.40817572021825116	   0.47462807596842654	   0.54123266056356256	   0.60635008732918749	   0.67635937509900323	   0.74999734823808617	   0.82672024509350972	   0.90470822031519593	   0.99447864612150461	    1.0876525840232032	    1.2883144631212438	    1.6686060464860328	    1.9823691006605508	    2.2612420818190415	;
  0.014423877591156847	   0.18034963396913584	   0.34478596303591114	   0.38455970319811150	   0.42465127758196208	   0.48253356391095886	   0.56471997006100361	   0.65324839286919845	   0.74197525543264742	   0.83195022621312742	   0.92525172906231545	    1.0233655488929969	    1.1247220848899047	    1.2276264776126034	    1.3353776597869695	    1.4521721928804132	    1.7141648855243377	    2.0555224219176473	    2.4359200299625554	    2.7788216050751875	;
 0.0088254893255818225	   0.20280309069054275	   0.38965617856274498	   0.44195611063932716	   0.49567846929660409	   0.57117493184341761	   0.67167009636636343	   0.77249662453751833	   0.87463255087234304	   0.98128336320322851	    1.0909780361698909	    1.2043848866778775	    1.3206654794111758	    1.4401716906981621	    1.5645155624323148	    1.7008130529026915	    1.9943203787525445	    2.3267433091207992	    2.7375968576736747	    3.1206775510286855	;
0.00059571745261831495	   0.23045758404522182	   0.45788843976448090	   0.53094471958245804	   0.60466565822291751	   0.70362396531256521	   0.82791405192253553	   0.95134519024911035	    1.0750599083163228	    1.2024542428856491	    1.3332999426525747	    1.4670222183930068	    1.6079524197241564	    1.7575328343046863	    1.9178452384571616	    2.0825865046150107	    2.4131892821018042	    2.7580415698851724	    3.2029038749974084	    3.6437818065120728	;
   0.00000000000000000	   0.25460342328928670	   0.51334306678408759	   0.59404959829990345	   0.67548085047635520	   0.78526368874758434	   0.92113026713046087	    1.0576096851763783	    1.1955354374701246	    1.3357712060934579	    1.4782365250252083	    1.6250798025207775	    1.7828448571301658	    1.9522955997359797	    2.1306132902169019	    2.3126014636814491	    2.6740036072243423	    3.0337043125999537	    3.5061384527120465	    3.9886846399936999	;
   0.00000000000000000	   0.27058782733040448	   0.54862600177499443	   0.63215327645540187	   0.71697171030142159	   0.83211834383804839	   0.97605561671032071	    1.1206136981355090	    1.2673875098852838	    1.4157906533003768	    1.5656184187889592	    1.7193644038363622	    1.8879730472872018	    2.0672566085138042	    2.2544101170701625	    2.4439302277722779	    2.8279918005576468	    3.1997832340555044	    3.6919970055222699	    4.2020450219717587	;
 0.0083951733986433585	   0.32713345762393520	   0.65235752139486203	   0.74717559855170357	   0.84292313708128885	   0.97332757662521630	    1.1388778572437268	    1.3078266574716029	    1.4815655151013010	    1.6588894281848179	    1.8351234034581230	    2.0150318676802184	    2.2057763839741273	    2.4007735461510693	    2.6033883444210186	    2.8185905454140023	    3.2771198772943229	    3.7106077362396266	    4.2919384605120046	    4.9082131754768241	;
  0.038354547915362150	   0.38194673731041318	   0.73185048367948846	   0.83946575608656304	   0.94807180785577316	    1.0942666207316378	    1.2802757177794253	    1.4694817761167795	    1.6613739990280603	    1.8574978488940888	    2.0575136740318380	    2.2612572261687771	    2.4691897791318471	    2.6868891245831219	    2.9113866798365264	    3.1464118822887683	    3.6433841888425427	    4.1631292546913476	    4.8866986869720881	    5.6483784344497261	;
  0.062541362705429066	   0.42045180282007877	   0.78611270970460378	   0.89935077244408634	    1.0134027328679551	    1.1669173251664895	    1.3626075966121005	    1.5616148072406202	    1.7651441256228921	    1.9734341375873692	    2.1840641266741088	    2.3989282748268206	    2.6226372544114716	    2.8495174286143627	    3.0851939113478077	    3.3306768138261260	    3.8523416979193956	    4.4392882958773061	    5.2645921808466696	    6.1268510829115908	;
  0.091179661903871084	   0.46531441293166004	   0.84746875220456674	   0.96597780946469192	    1.0853618040960762	    1.2456583653542022	    1.4507008220404962	    1.6593327047551909	    1.8737552519230971	    2.0928948973702335	    2.3161533251429032	    2.5426046761076515	    2.7809614110266478	    3.0195717231914254	    3.2681340446136971	    3.5263818571458563	    4.0715597864343334	    4.7386764989114409	    5.6781267197959551	    6.6528859676805379	;
   0.14081846763305822	   0.54569700743299610	   0.95479683782397973	    1.0804465313444418	    1.2069320404437087	    1.3758798807706951	    1.5939135878014887	    1.8179177570834366	    2.0474030406790535	    2.2802025418582716	    2.5221270226005350	    2.7664511665287543	    3.0204529444154331	    3.2847297402117506	    3.5530087271300248	    3.8376855525449116	    4.4238831276561745	    5.2379368687579344	    6.3621826730610742	    7.5232079355574522	;
   0.18922070541366029	   0.63550319465945004	    1.0774422585022880	    1.2092878309871529	    1.3411394139810893	    1.5176120764801102	    1.7491963078188568	    1.9895853969402355	    2.2327322618811642	    2.4792703868830097	    2.7329698886674252	    2.9933875434633412	    3.2666463112469373	    3.5452063294262146	    3.8327919275352360	    4.1283626682283252	    4.7944692624281151	    5.8006939102709509	    7.1091856718315221	    8.4648478640162157	;
   0.23332427598918529	   0.74313669165296337	    1.2377114988542779	    1.3809790847337413	    1.5226775354826740	    1.7061349070225658	    1.9460158667195901	    2.1966046690110472	    2.4578834678477475	    2.7293478068216346	    3.0094910575963274	    3.2885790928564811	    3.5930762916891590	    3.8954147812012798	    4.2100767944985051	    4.5314331790250977	    5.3031773615119882	    6.5213846187567963	    8.1076326160390888	    9.7024857848649582	;
   0.24803712022757390	   0.81171131986020595	    1.3543002271310345	    1.5059804510667119	    1.6550054772420597	    1.8497968772489419	    2.1089815718685481	    2.3701671011434873	    2.6317872282496189	    2.9210903535319441	    3.2142072302091740	    3.5166063258023996	    3.8527966693718878	    4.2059100142026971	    4.5795512067353368	    4.9678526287905580	    5.9249342606035880	    7.2017812412058868	    8.9582606717112405	    10.715291592200684	;
   0.23650180250129713	   0.87367485964460290	    1.5072825570619315	    1.6958175059767844	    1.8835814360889607	    2.1299238789686687	    2.4187025052413400	    2.6403312201888380	    2.9053113899532810	    3.2333133704250008	    3.5580226422722681	    3.8957417903032128	    4.2787069929555379	    4.7215606086480051	    5.2818282932826603	    5.8950668767174230	    7.0119591927814353	    8.3521695397028459	    10.267574115130783	    12.191156820707368	;
   0.19592235712312103	   0.90813102828514913	    1.6258319945767652	    1.8456071182051630	    2.0671977475525294	    2.3689776154530531	    2.7769662748850297	    3.0131996085295412	    3.2916438691384302	    3.6360435662514554	    4.0181838467191744	    4.4297519275691091	    4.8758217343055872	    5.3783134749159851	    5.9394592325870468	    6.5660234006813791	    8.0203240350030089	    9.6211748672246031	    11.671576129693555	    13.690251491765968	;
   0.16109144714607740	   0.92864391312014083	    1.7048308249205018	    1.9445790938019525	    2.1865796715083867	    2.5131659931738080	    2.9224859352478312	    3.2829752588315211	    3.6305047223338662	    4.0502217017993303	    4.4443388687749232	    4.7911534979995398	    5.2018841536484182	    5.7118524216766877	    6.3310686889176218	    7.0327622639680838	    8.6940253664238583	    10.503124689863139	    12.634683481669587	    14.728276514844197	;
   0.12781923910739287	   0.94484314034474559	    1.7681958111055951	    2.0155195364616922	    2.2624564288875026	    2.5889707546826970	    2.9882592803126395	    3.3726547525412633	    3.7474132134916642	    4.2232806947838215	    4.6372700882190045	    5.0226027847723058	    5.4589947807588048	    6.0126300057655246	    6.7061522929624227	    7.4805710124903424	    9.2832345027141745	    11.259509840778231	    13.472077690265346	    15.661281444241071	;
  0.094878715558365107	   0.95339835318075150	    1.8122654587050111	    2.0649426698927127	    2.3157562456966225	    2.6445681941127295	    3.0429235847113278	    3.4310087186963782	    3.8375388590452815	    4.2922110816225407	    4.7752875381719635	    5.2302791204762453	    5.7473887101280203	    6.3851093170200963	    7.1227104887018635	    7.9366909303555433	    9.8211765597900058	    11.879081486529264	    14.231309811976301	    16.547661780673064	;
  0.060584623064161354	   0.95158345267412303	    1.8379274786091695	    2.0988753958455169	    2.3584081589289383	    2.7005184570921843	    3.1191569394655696	    3.5225028729257275	    3.9240877441101927	    4.3995840218357793	    4.9250723035102251	    5.4822273519037541	    6.1025533514372237	    6.8003740251355165	    7.5710867719375949	    8.4105233781696125	    10.335708822226989	    12.424010866445069	    14.949614892426233	    17.425742062398665	;
  0.026929960853541726	   0.94112135776324579	    1.8501355990558312	    2.1206423866070589	    2.3908590897603172	    2.7506561175093101	    3.2027720304521980	    3.6534563664417248	    4.0739036934210731	    4.5656959794623040	    5.1271192143217545	    5.7517752936330284	    6.4410482786254111	    7.1870225447969416	    7.9945656826972593	    8.8590535516626172	    10.806023422652897	    12.916329701067315	    15.596504065826283	    18.241527547833474	;
   0.00000000000000000	   0.92198791162471150	    1.8566700069095119	    2.1385546066387509	    2.4210964907260708	    2.7991114053612072	    3.2775082754899860	    3.7620731226925272	    4.2600359861122454	    4.8011709511904899	    5.4087315507769631	    6.0858844021080669	    6.8294087761958879	    7.6237637675466337	    8.4716200819855771	    9.3660030610768494	    11.335004047288241	    13.475385683201171	    16.313876474727621	    19.162699467912802	;
   0.00000000000000000	   0.91038657580766569	    1.8604988338497972	    2.1529380312322641	    2.4467241694449013	    2.8414406325375667	    3.3474610854065885	    3.8765397465425591	    4.4406741393498566	    5.0460925691674881	    5.7084399762209568	    6.4332347802100083	    7.2218520020643036	    8.0589461067537869	    8.9444786856103224	    9.8685575104767462	    11.862471404959800	    14.037759881912226	    17.023963140467341	    20.080075476608780	]; 

% Fuel Properties
engine.fuel = class_REVS_fuel('FTAG 25278');

% Idle Speed
engine.idle_speed_radps = class_REVS_dynamic_lookup;
engine.idle_speed_radps.axis_1.signal =  'veh_spd_mps'; 
engine.idle_speed_radps.axis_1.breakpoints = [	    0.00000000000000000	    10.000000000000000	    20.000000000000000		]; 
engine.idle_speed_radps.table = [	     71.733032256966936	    71.733032256966936	    73.303828583761842		]; 

% Pedal Calibration
engine.pedal_map_type = enum_engine_pedal_map_type.max_engine_power;

% Calibration Adjustment Factors
% -- None -- 
